/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.cables.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.client.CustomRenderTypes;
import mcjty.xnet.modules.cables.CableColor;
import mcjty.xnet.modules.cables.ConnectorType;
import mcjty.xnet.modules.cables.blocks.GenericCableBlock;
import mcjty.xnet.modules.facade.IFacadeSupport;
import mcjty.xnet.modules.facade.blocks.FacadeBlock;
import mcjty.xnet.setup.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelLastEvent;

public class CableWorldRenderer {
    public static void tick(RenderLevelLastEvent evt) {
        Minecraft mc = Minecraft.m_91087_();
        ItemStack heldItem = mc.f_91074_.m_21120_(InteractionHand.MAIN_HAND);
        if (!heldItem.m_41619_() && heldItem.m_41720_() instanceof BlockItem && ((BlockItem)heldItem.m_41720_()).m_40614_() instanceof GenericCableBlock) {
            CableWorldRenderer.renderCables(evt, mc);
        }
    }

    private static void renderCables(RenderLevelLastEvent evt, Minecraft mc) {
        LocalPlayer p = mc.f_91074_;
        PoseStack matrixStack = evt.getPoseStack();
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer builder = buffer.m_6299_(CustomRenderTypes.OVERLAY_LINES);
        ClientLevel world = mc.f_91073_;
        matrixStack.m_85836_();
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        matrixStack.m_85837_(-projectedView.f_82479_, -projectedView.f_82480_, -projectedView.f_82481_);
        Matrix4f positionMatrix = matrixStack.m_85850_().m_85861_();
        for (int dx = -20; dx <= 20; ++dx) {
            for (int dy = -20; dy <= 20; ++dy) {
                for (int dz = -20; dz <= 20; ++dz) {
                    BlockPos c = p.m_142538_().m_142082_(dx, dy, dz);
                    BlockState state = world.m_8055_(c);
                    Block block = state.m_60734_();
                    if (!(block instanceof GenericCableBlock)) continue;
                    BlockEntity te = world.m_7702_(c);
                    if (te instanceof IFacadeSupport) {
                        BlockState facadeId = ((IFacadeSupport)te).getMimicBlock();
                        if (!(((Boolean)Config.showNonFacadedCablesWhileSneaking.get()).booleanValue() && p.m_6144_() || facadeId != null || block instanceof FacadeBlock)) {
                            continue;
                        }
                    } else if (!((Boolean)Config.showNonFacadedCablesWhileSneaking.get()).booleanValue() || !p.m_6144_()) continue;
                    CableColor color = (CableColor)((Object)state.m_61143_(GenericCableBlock.COLOR));
                    float r = 0.0f;
                    float g = 0.0f;
                    float b = 0.0f;
                    switch (color) {
                        case BLUE: {
                            r = 0.4f;
                            g = 0.4f;
                            b = 1.0f;
                            break;
                        }
                        case RED: {
                            r = 1.0f;
                            g = 0.4f;
                            b = 0.4f;
                            break;
                        }
                        case YELLOW: {
                            r = 1.0f;
                            g = 1.0f;
                            b = 0.4f;
                            break;
                        }
                        case GREEN: {
                            r = 0.4f;
                            g = 1.0f;
                            b = 0.4f;
                            break;
                        }
                        case ROUTING: {
                            r = 0.7f;
                            g = 0.7f;
                            b = 0.7f;
                        }
                    }
                    List<Rect> quads = CableWorldRenderer.getQuads(state);
                    for (Rect quad : quads) {
                        CableWorldRenderer.renderRect(builder, positionMatrix, quad, c, r, g, b, 0.5f);
                    }
                }
            }
        }
        matrixStack.m_85849_();
        RenderSystem.m_69465_();
        buffer.m_109912_(CustomRenderTypes.OVERLAY_LINES);
    }

    private static Vec3 v(double x, double y, double z) {
        return new Vec3(x, y, z);
    }

    private static List<Rect> getQuads(BlockState state) {
        ConnectorType north = (ConnectorType)((Object)state.m_61143_(GenericCableBlock.NORTH));
        ConnectorType south = (ConnectorType)((Object)state.m_61143_(GenericCableBlock.SOUTH));
        ConnectorType west = (ConnectorType)((Object)state.m_61143_(GenericCableBlock.WEST));
        ConnectorType east = (ConnectorType)((Object)state.m_61143_(GenericCableBlock.EAST));
        ConnectorType up = (ConnectorType)((Object)state.m_61143_(GenericCableBlock.UP));
        ConnectorType down = (ConnectorType)((Object)state.m_61143_(GenericCableBlock.DOWN));
        ArrayList<Rect> quads = new ArrayList<Rect>();
        double o = 0.4;
        double p = 0.1;
        double q = 0.2;
        if (up == ConnectorType.CABLE) {
            quads.add(new Rect(CableWorldRenderer.v(1.0 - o, 1.0, o), CableWorldRenderer.v(1.0 - o, 1.0, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - o, o)));
            quads.add(new Rect(CableWorldRenderer.v(o, 1.0, 1.0 - o), CableWorldRenderer.v(o, 1.0, o), CableWorldRenderer.v(o, 1.0 - o, o), CableWorldRenderer.v(o, 1.0 - o, 1.0 - o)));
            quads.add(new Rect(CableWorldRenderer.v(o, 1.0, o), CableWorldRenderer.v(1.0 - o, 1.0, o), CableWorldRenderer.v(1.0 - o, 1.0 - o, o), CableWorldRenderer.v(o, 1.0 - o, o)));
            quads.add(new Rect(CableWorldRenderer.v(o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0, 1.0 - o), CableWorldRenderer.v(o, 1.0, 1.0 - o)));
        } else if (up == ConnectorType.BLOCK) {
            quads.add(new Rect(CableWorldRenderer.v(1.0 - o, 1.0 - p, o), CableWorldRenderer.v(1.0 - o, 1.0 - p, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - o, o)));
            quads.add(new Rect(CableWorldRenderer.v(o, 1.0 - p, 1.0 - o), CableWorldRenderer.v(o, 1.0 - p, o), CableWorldRenderer.v(o, 1.0 - o, o), CableWorldRenderer.v(o, 1.0 - o, 1.0 - o)));
            quads.add(new Rect(CableWorldRenderer.v(o, 1.0 - p, o), CableWorldRenderer.v(1.0 - o, 1.0 - p, o), CableWorldRenderer.v(1.0 - o, 1.0 - o, o), CableWorldRenderer.v(o, 1.0 - o, o)));
            quads.add(new Rect(CableWorldRenderer.v(o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - p, 1.0 - o), CableWorldRenderer.v(o, 1.0 - p, 1.0 - o)));
            quads.add(new Rect(CableWorldRenderer.v(1.0 - q, 1.0 - p, q), CableWorldRenderer.v(1.0 - q, 1.0, q), CableWorldRenderer.v(1.0 - q, 1.0, 1.0 - q), CableWorldRenderer.v(1.0 - q, 1.0 - p, 1.0 - q)));
            quads.add(new Rect(CableWorldRenderer.v(q, 1.0 - p, 1.0 - q), CableWorldRenderer.v(q, 1.0, 1.0 - q), CableWorldRenderer.v(q, 1.0, q), CableWorldRenderer.v(q, 1.0 - p, q)));
            quads.add(new Rect(CableWorldRenderer.v(q, 1.0, q), CableWorldRenderer.v(1.0 - q, 1.0, q), CableWorldRenderer.v(1.0 - q, 1.0 - p, q), CableWorldRenderer.v(q, 1.0 - p, q)));
            quads.add(new Rect(CableWorldRenderer.v(q, 1.0 - p, 1.0 - q), CableWorldRenderer.v(1.0 - q, 1.0 - p, 1.0 - q), CableWorldRenderer.v(1.0 - q, 1.0, 1.0 - q), CableWorldRenderer.v(q, 1.0, 1.0 - q)));
            quads.add(new Rect(CableWorldRenderer.v(q, 1.0 - p, q), CableWorldRenderer.v(1.0 - q, 1.0 - p, q), CableWorldRenderer.v(1.0 - q, 1.0 - p, 1.0 - q), CableWorldRenderer.v(q, 1.0 - p, 1.0 - q)));
            quads.add(new Rect(CableWorldRenderer.v(q, 1.0, q), CableWorldRenderer.v(q, 1.0, 1.0 - q), CableWorldRenderer.v(1.0 - q, 1.0, 1.0 - q), CableWorldRenderer.v(1.0 - q, 1.0, q)));
        } else {
            quads.add(new Rect(CableWorldRenderer.v(o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - o, o), CableWorldRenderer.v(o, 1.0 - o, o)));
        }
        if (down == ConnectorType.CABLE) {
            quads.add(new Rect(CableWorldRenderer.v(1.0 - o, o, o), CableWorldRenderer.v(1.0 - o, o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 0.0, 1.0 - o), CableWorldRenderer.v(1.0 - o, 0.0, o)));
            quads.add(new Rect(CableWorldRenderer.v(o, o, 1.0 - o), CableWorldRenderer.v(o, o, o), CableWorldRenderer.v(o, 0.0, o), CableWorldRenderer.v(o, 0.0, 1.0 - o)));
            quads.add(new Rect(CableWorldRenderer.v(o, o, o), CableWorldRenderer.v(1.0 - o, o, o), CableWorldRenderer.v(1.0 - o, 0.0, o), CableWorldRenderer.v(o, 0.0, o)));
            quads.add(new Rect(CableWorldRenderer.v(o, 0.0, 1.0 - o), CableWorldRenderer.v(1.0 - o, 0.0, 1.0 - o), CableWorldRenderer.v(1.0 - o, o, 1.0 - o), CableWorldRenderer.v(o, o, 1.0 - o)));
        } else if (down == ConnectorType.BLOCK) {
            quads.add(new Rect(CableWorldRenderer.v(1.0 - o, o, o), CableWorldRenderer.v(1.0 - o, o, 1.0 - o), CableWorldRenderer.v(1.0 - o, p, 1.0 - o), CableWorldRenderer.v(1.0 - o, p, o)));
            quads.add(new Rect(CableWorldRenderer.v(o, o, 1.0 - o), CableWorldRenderer.v(o, o, o), CableWorldRenderer.v(o, p, o), CableWorldRenderer.v(o, p, 1.0 - o)));
            quads.add(new Rect(CableWorldRenderer.v(o, o, o), CableWorldRenderer.v(1.0 - o, o, o), CableWorldRenderer.v(1.0 - o, p, o), CableWorldRenderer.v(o, p, o)));
            quads.add(new Rect(CableWorldRenderer.v(o, p, 1.0 - o), CableWorldRenderer.v(1.0 - o, p, 1.0 - o), CableWorldRenderer.v(1.0 - o, o, 1.0 - o), CableWorldRenderer.v(o, o, 1.0 - o)));
            quads.add(new Rect(CableWorldRenderer.v(1.0 - q, 0.0, q), CableWorldRenderer.v(1.0 - q, p, q), CableWorldRenderer.v(1.0 - q, p, 1.0 - q), CableWorldRenderer.v(1.0 - q, 0.0, 1.0 - q)));
            quads.add(new Rect(CableWorldRenderer.v(q, 0.0, 1.0 - q), CableWorldRenderer.v(q, p, 1.0 - q), CableWorldRenderer.v(q, p, q), CableWorldRenderer.v(q, 0.0, q)));
            quads.add(new Rect(CableWorldRenderer.v(q, p, q), CableWorldRenderer.v(1.0 - q, p, q), CableWorldRenderer.v(1.0 - q, 0.0, q), CableWorldRenderer.v(q, 0.0, q)));
            quads.add(new Rect(CableWorldRenderer.v(q, 0.0, 1.0 - q), CableWorldRenderer.v(1.0 - q, 0.0, 1.0 - q), CableWorldRenderer.v(1.0 - q, p, 1.0 - q), CableWorldRenderer.v(q, p, 1.0 - q)));
            quads.add(new Rect(CableWorldRenderer.v(q, p, 1.0 - q), CableWorldRenderer.v(1.0 - q, p, 1.0 - q), CableWorldRenderer.v(1.0 - q, p, q), CableWorldRenderer.v(q, p, q)));
            quads.add(new Rect(CableWorldRenderer.v(q, 0.0, 1.0 - q), CableWorldRenderer.v(q, 0.0, q), CableWorldRenderer.v(1.0 - q, 0.0, q), CableWorldRenderer.v(1.0 - q, 0.0, 1.0 - q)));
        } else {
            quads.add(new Rect(CableWorldRenderer.v(o, o, o), CableWorldRenderer.v(1.0 - o, o, o), CableWorldRenderer.v(1.0 - o, o, 1.0 - o), CableWorldRenderer.v(o, o, 1.0 - o)));
        }
        if (east == ConnectorType.CABLE) {
            quads.add(new Rect(CableWorldRenderer.v(1.0, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0, 1.0 - o, o), CableWorldRenderer.v(1.0 - o, 1.0 - o, o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - o)));
            quads.add(new Rect(CableWorldRenderer.v(1.0, o, o), CableWorldRenderer.v(1.0, o, 1.0 - o), CableWorldRenderer.v(1.0 - o, o, 1.0 - o), CableWorldRenderer.v(1.0 - o, o, o)));
            quads.add(new Rect(CableWorldRenderer.v(1.0, 1.0 - o, o), CableWorldRenderer.v(1.0, o, o), CableWorldRenderer.v(1.0 - o, o, o), CableWorldRenderer.v(1.0 - o, 1.0 - o, o)));
            quads.add(new Rect(CableWorldRenderer.v(1.0, o, 1.0 - o), CableWorldRenderer.v(1.0, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - o, o, 1.0 - o)));
        } else if (east == ConnectorType.BLOCK) {
            quads.add(new Rect(CableWorldRenderer.v(1.0 - p, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - p, 1.0 - o, o), CableWorldRenderer.v(1.0 - o, 1.0 - o, o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - o)));
            quads.add(new Rect(CableWorldRenderer.v(1.0 - p, o, o), CableWorldRenderer.v(1.0 - p, o, 1.0 - o), CableWorldRenderer.v(1.0 - o, o, 1.0 - o), CableWorldRenderer.v(1.0 - o, o, o)));
            quads.add(new Rect(CableWorldRenderer.v(1.0 - p, 1.0 - o, o), CableWorldRenderer.v(1.0 - p, o, o), CableWorldRenderer.v(1.0 - o, o, o), CableWorldRenderer.v(1.0 - o, 1.0 - o, o)));
            quads.add(new Rect(CableWorldRenderer.v(1.0 - p, o, 1.0 - o), CableWorldRenderer.v(1.0 - p, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - o, o, 1.0 - o)));
            quads.add(new Rect(CableWorldRenderer.v(1.0 - p, 1.0 - q, 1.0 - q), CableWorldRenderer.v(1.0, 1.0 - q, 1.0 - q), CableWorldRenderer.v(1.0, 1.0 - q, q), CableWorldRenderer.v(1.0 - p, 1.0 - q, q)));
            quads.add(new Rect(CableWorldRenderer.v(1.0 - p, q, q), CableWorldRenderer.v(1.0, q, q), CableWorldRenderer.v(1.0, q, 1.0 - q), CableWorldRenderer.v(1.0 - p, q, 1.0 - q)));
            quads.add(new Rect(CableWorldRenderer.v(1.0 - p, 1.0 - q, q), CableWorldRenderer.v(1.0, 1.0 - q, q), CableWorldRenderer.v(1.0, q, q), CableWorldRenderer.v(1.0 - p, q, q)));
            quads.add(new Rect(CableWorldRenderer.v(1.0 - p, q, 1.0 - q), CableWorldRenderer.v(1.0, q, 1.0 - q), CableWorldRenderer.v(1.0, 1.0 - q, 1.0 - q), CableWorldRenderer.v(1.0 - p, 1.0 - q, 1.0 - q)));
            quads.add(new Rect(CableWorldRenderer.v(1.0 - p, q, 1.0 - q), CableWorldRenderer.v(1.0 - p, 1.0 - q, 1.0 - q), CableWorldRenderer.v(1.0 - p, 1.0 - q, q), CableWorldRenderer.v(1.0 - p, q, q)));
            quads.add(new Rect(CableWorldRenderer.v(1.0, q, 1.0 - q), CableWorldRenderer.v(1.0, q, q), CableWorldRenderer.v(1.0, 1.0 - q, q), CableWorldRenderer.v(1.0, 1.0 - q, 1.0 - q)));
        } else {
            quads.add(new Rect(CableWorldRenderer.v(1.0 - o, o, o), CableWorldRenderer.v(1.0 - o, 1.0 - o, o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - o, o, 1.0 - o)));
        }
        if (west == ConnectorType.CABLE) {
            quads.add(new Rect(CableWorldRenderer.v(o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(o, 1.0 - o, o), CableWorldRenderer.v(0.0, 1.0 - o, o), CableWorldRenderer.v(0.0, 1.0 - o, 1.0 - o)));
            quads.add(new Rect(CableWorldRenderer.v(o, o, o), CableWorldRenderer.v(o, o, 1.0 - o), CableWorldRenderer.v(0.0, o, 1.0 - o), CableWorldRenderer.v(0.0, o, o)));
            quads.add(new Rect(CableWorldRenderer.v(o, 1.0 - o, o), CableWorldRenderer.v(o, o, o), CableWorldRenderer.v(0.0, o, o), CableWorldRenderer.v(0.0, 1.0 - o, o)));
            quads.add(new Rect(CableWorldRenderer.v(o, o, 1.0 - o), CableWorldRenderer.v(o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(0.0, 1.0 - o, 1.0 - o), CableWorldRenderer.v(0.0, o, 1.0 - o)));
        } else if (west == ConnectorType.BLOCK) {
            quads.add(new Rect(CableWorldRenderer.v(o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(o, 1.0 - o, o), CableWorldRenderer.v(p, 1.0 - o, o), CableWorldRenderer.v(p, 1.0 - o, 1.0 - o)));
            quads.add(new Rect(CableWorldRenderer.v(o, o, o), CableWorldRenderer.v(o, o, 1.0 - o), CableWorldRenderer.v(p, o, 1.0 - o), CableWorldRenderer.v(p, o, o)));
            quads.add(new Rect(CableWorldRenderer.v(o, 1.0 - o, o), CableWorldRenderer.v(o, o, o), CableWorldRenderer.v(p, o, o), CableWorldRenderer.v(p, 1.0 - o, o)));
            quads.add(new Rect(CableWorldRenderer.v(o, o, 1.0 - o), CableWorldRenderer.v(o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(p, 1.0 - o, 1.0 - o), CableWorldRenderer.v(p, o, 1.0 - o)));
            quads.add(new Rect(CableWorldRenderer.v(0.0, 1.0 - q, 1.0 - q), CableWorldRenderer.v(p, 1.0 - q, 1.0 - q), CableWorldRenderer.v(p, 1.0 - q, q), CableWorldRenderer.v(0.0, 1.0 - q, q)));
            quads.add(new Rect(CableWorldRenderer.v(0.0, q, q), CableWorldRenderer.v(p, q, q), CableWorldRenderer.v(p, q, 1.0 - q), CableWorldRenderer.v(0.0, q, 1.0 - q)));
            quads.add(new Rect(CableWorldRenderer.v(0.0, 1.0 - q, q), CableWorldRenderer.v(p, 1.0 - q, q), CableWorldRenderer.v(p, q, q), CableWorldRenderer.v(0.0, q, q)));
            quads.add(new Rect(CableWorldRenderer.v(0.0, q, 1.0 - q), CableWorldRenderer.v(p, q, 1.0 - q), CableWorldRenderer.v(p, 1.0 - q, 1.0 - q), CableWorldRenderer.v(0.0, 1.0 - q, 1.0 - q)));
            quads.add(new Rect(CableWorldRenderer.v(p, q, q), CableWorldRenderer.v(p, 1.0 - q, q), CableWorldRenderer.v(p, 1.0 - q, 1.0 - q), CableWorldRenderer.v(p, q, 1.0 - q)));
            quads.add(new Rect(CableWorldRenderer.v(0.0, q, q), CableWorldRenderer.v(0.0, q, 1.0 - q), CableWorldRenderer.v(0.0, 1.0 - q, 1.0 - q), CableWorldRenderer.v(0.0, 1.0 - q, q)));
        } else {
            quads.add(new Rect(CableWorldRenderer.v(o, o, 1.0 - o), CableWorldRenderer.v(o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(o, 1.0 - o, o), CableWorldRenderer.v(o, o, o)));
        }
        if (north == ConnectorType.CABLE) {
            quads.add(new Rect(CableWorldRenderer.v(o, 1.0 - o, o), CableWorldRenderer.v(1.0 - o, 1.0 - o, o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 0.0), CableWorldRenderer.v(o, 1.0 - o, 0.0)));
            quads.add(new Rect(CableWorldRenderer.v(o, o, 0.0), CableWorldRenderer.v(1.0 - o, o, 0.0), CableWorldRenderer.v(1.0 - o, o, o), CableWorldRenderer.v(o, o, o)));
            quads.add(new Rect(CableWorldRenderer.v(1.0 - o, o, 0.0), CableWorldRenderer.v(1.0 - o, 1.0 - o, 0.0), CableWorldRenderer.v(1.0 - o, 1.0 - o, o), CableWorldRenderer.v(1.0 - o, o, o)));
            quads.add(new Rect(CableWorldRenderer.v(o, o, o), CableWorldRenderer.v(o, 1.0 - o, o), CableWorldRenderer.v(o, 1.0 - o, 0.0), CableWorldRenderer.v(o, o, 0.0)));
        } else if (north == ConnectorType.BLOCK) {
            quads.add(new Rect(CableWorldRenderer.v(o, 1.0 - o, o), CableWorldRenderer.v(1.0 - o, 1.0 - o, o), CableWorldRenderer.v(1.0 - o, 1.0 - o, p), CableWorldRenderer.v(o, 1.0 - o, p)));
            quads.add(new Rect(CableWorldRenderer.v(o, o, p), CableWorldRenderer.v(1.0 - o, o, p), CableWorldRenderer.v(1.0 - o, o, o), CableWorldRenderer.v(o, o, o)));
            quads.add(new Rect(CableWorldRenderer.v(1.0 - o, o, p), CableWorldRenderer.v(1.0 - o, 1.0 - o, p), CableWorldRenderer.v(1.0 - o, 1.0 - o, o), CableWorldRenderer.v(1.0 - o, o, o)));
            quads.add(new Rect(CableWorldRenderer.v(o, o, o), CableWorldRenderer.v(o, 1.0 - o, o), CableWorldRenderer.v(o, 1.0 - o, p), CableWorldRenderer.v(o, o, p)));
            quads.add(new Rect(CableWorldRenderer.v(q, 1.0 - q, p), CableWorldRenderer.v(1.0 - q, 1.0 - q, p), CableWorldRenderer.v(1.0 - q, 1.0 - q, 0.0), CableWorldRenderer.v(q, 1.0 - q, 0.0)));
            quads.add(new Rect(CableWorldRenderer.v(q, q, 0.0), CableWorldRenderer.v(1.0 - q, q, 0.0), CableWorldRenderer.v(1.0 - q, q, p), CableWorldRenderer.v(q, q, p)));
            quads.add(new Rect(CableWorldRenderer.v(1.0 - q, q, 0.0), CableWorldRenderer.v(1.0 - q, 1.0 - q, 0.0), CableWorldRenderer.v(1.0 - q, 1.0 - q, p), CableWorldRenderer.v(1.0 - q, q, p)));
            quads.add(new Rect(CableWorldRenderer.v(q, q, p), CableWorldRenderer.v(q, 1.0 - q, p), CableWorldRenderer.v(q, 1.0 - q, 0.0), CableWorldRenderer.v(q, q, 0.0)));
            quads.add(new Rect(CableWorldRenderer.v(q, q, p), CableWorldRenderer.v(1.0 - q, q, p), CableWorldRenderer.v(1.0 - q, 1.0 - q, p), CableWorldRenderer.v(q, 1.0 - q, p)));
            quads.add(new Rect(CableWorldRenderer.v(q, q, 0.0), CableWorldRenderer.v(q, 1.0 - q, 0.0), CableWorldRenderer.v(1.0 - q, 1.0 - q, 0.0), CableWorldRenderer.v(1.0 - q, q, 0.0)));
        } else {
            quads.add(new Rect(CableWorldRenderer.v(o, 1.0 - o, o), CableWorldRenderer.v(1.0 - o, 1.0 - o, o), CableWorldRenderer.v(1.0 - o, o, o), CableWorldRenderer.v(o, o, o)));
        }
        if (south == ConnectorType.CABLE) {
            quads.add(new Rect(CableWorldRenderer.v(o, 1.0 - o, 1.0), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(o, 1.0 - o, 1.0 - o)));
            quads.add(new Rect(CableWorldRenderer.v(o, o, 1.0 - o), CableWorldRenderer.v(1.0 - o, o, 1.0 - o), CableWorldRenderer.v(1.0 - o, o, 1.0), CableWorldRenderer.v(o, o, 1.0)));
            quads.add(new Rect(CableWorldRenderer.v(1.0 - o, o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0), CableWorldRenderer.v(1.0 - o, o, 1.0)));
            quads.add(new Rect(CableWorldRenderer.v(o, o, 1.0), CableWorldRenderer.v(o, 1.0 - o, 1.0), CableWorldRenderer.v(o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(o, o, 1.0 - o)));
        } else if (south == ConnectorType.BLOCK) {
            quads.add(new Rect(CableWorldRenderer.v(o, 1.0 - o, 1.0 - p), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - p), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(o, 1.0 - o, 1.0 - o)));
            quads.add(new Rect(CableWorldRenderer.v(o, o, 1.0 - o), CableWorldRenderer.v(1.0 - o, o, 1.0 - o), CableWorldRenderer.v(1.0 - o, o, 1.0 - p), CableWorldRenderer.v(o, o, 1.0 - p)));
            quads.add(new Rect(CableWorldRenderer.v(1.0 - o, o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - p), CableWorldRenderer.v(1.0 - o, o, 1.0 - p)));
            quads.add(new Rect(CableWorldRenderer.v(o, o, 1.0 - p), CableWorldRenderer.v(o, 1.0 - o, 1.0 - p), CableWorldRenderer.v(o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(o, o, 1.0 - o)));
            quads.add(new Rect(CableWorldRenderer.v(q, 1.0 - q, 1.0), CableWorldRenderer.v(1.0 - q, 1.0 - q, 1.0), CableWorldRenderer.v(1.0 - q, 1.0 - q, 1.0 - p), CableWorldRenderer.v(q, 1.0 - q, 1.0 - p)));
            quads.add(new Rect(CableWorldRenderer.v(q, q, 1.0 - p), CableWorldRenderer.v(1.0 - q, q, 1.0 - p), CableWorldRenderer.v(1.0 - q, q, 1.0), CableWorldRenderer.v(q, q, 1.0)));
            quads.add(new Rect(CableWorldRenderer.v(1.0 - q, q, 1.0 - p), CableWorldRenderer.v(1.0 - q, 1.0 - q, 1.0 - p), CableWorldRenderer.v(1.0 - q, 1.0 - q, 1.0), CableWorldRenderer.v(1.0 - q, q, 1.0)));
            quads.add(new Rect(CableWorldRenderer.v(q, q, 1.0), CableWorldRenderer.v(q, 1.0 - q, 1.0), CableWorldRenderer.v(q, 1.0 - q, 1.0 - p), CableWorldRenderer.v(q, q, 1.0 - p)));
            quads.add(new Rect(CableWorldRenderer.v(q, 1.0 - q, 1.0 - p), CableWorldRenderer.v(1.0 - q, 1.0 - q, 1.0 - p), CableWorldRenderer.v(1.0 - q, q, 1.0 - p), CableWorldRenderer.v(q, q, 1.0 - p)));
            quads.add(new Rect(CableWorldRenderer.v(q, 1.0 - q, 1.0), CableWorldRenderer.v(q, q, 1.0), CableWorldRenderer.v(1.0 - q, q, 1.0), CableWorldRenderer.v(1.0 - q, 1.0 - q, 1.0)));
        } else {
            quads.add(new Rect(CableWorldRenderer.v(o, o, 1.0 - o), CableWorldRenderer.v(1.0 - o, o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(o, 1.0 - o, 1.0 - o)));
        }
        return quads;
    }

    public static void renderRect(VertexConsumer buffer, Matrix4f positionMatrix, Rect rect, BlockPos p, float r, float g, float b, float a) {
        buffer.m_85982_(positionMatrix, (float)((double)p.m_123341_() + rect.v1.f_82479_), (float)((double)p.m_123342_() + rect.v1.f_82480_), (float)((double)p.m_123343_() + rect.v1.f_82481_)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(positionMatrix, (float)((double)p.m_123341_() + rect.v2.f_82479_), (float)((double)p.m_123342_() + rect.v2.f_82480_), (float)((double)p.m_123343_() + rect.v2.f_82481_)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(positionMatrix, (float)((double)p.m_123341_() + rect.v2.f_82479_), (float)((double)p.m_123342_() + rect.v2.f_82480_), (float)((double)p.m_123343_() + rect.v2.f_82481_)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(positionMatrix, (float)((double)p.m_123341_() + rect.v3.f_82479_), (float)((double)p.m_123342_() + rect.v3.f_82480_), (float)((double)p.m_123343_() + rect.v3.f_82481_)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(positionMatrix, (float)((double)p.m_123341_() + rect.v3.f_82479_), (float)((double)p.m_123342_() + rect.v3.f_82480_), (float)((double)p.m_123343_() + rect.v3.f_82481_)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(positionMatrix, (float)((double)p.m_123341_() + rect.v4.f_82479_), (float)((double)p.m_123342_() + rect.v4.f_82480_), (float)((double)p.m_123343_() + rect.v4.f_82481_)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(positionMatrix, (float)((double)p.m_123341_() + rect.v4.f_82479_), (float)((double)p.m_123342_() + rect.v4.f_82480_), (float)((double)p.m_123343_() + rect.v4.f_82481_)).m_85950_(r, g, b, a).m_5752_();
        buffer.m_85982_(positionMatrix, (float)((double)p.m_123341_() + rect.v1.f_82479_), (float)((double)p.m_123342_() + rect.v1.f_82480_), (float)((double)p.m_123343_() + rect.v1.f_82481_)).m_85950_(r, g, b, a).m_5752_();
    }

    private record Rect(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4) {
    }
}

